unit Unit1;

//      Arc, Pie, Chord,
//     TCanvas.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonPaint: TButton;
    Image1: TImage;
    ComboBoxMethod: TComboBox;
    ComboBoxStart: TComboBox;
    ComboBoxStop: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    LabelTitle: TLabel;
    ButtonExit: TButton;
    procedure ButtonPaintClick(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//  RqImage   
procedure ClearImage (RqImage : TImage);
var R : TRect;
begin
  R  := Rect(0,0, RqImage.Width,RqImage.Height);
  with RqImage.Canvas
  do begin
    Brush.Style := bsSolid;
    //    
    Brush.Color := RqImage.Parent.Brush.Color;
    Pen.Style := psClear;
    FillRect(R);
  end;
end;

//   ,  .
procedure ShowBigPoint (RqImage : TImage; X,Y : integer; RqColor : TColor);
const WPoint = 6;
      Hpoint = 6;
var R : TRect;
begin
   R  := Rect(X - (WPoint div 2), Y - (HPoint div 2),
              X + (WPoint div 2), Y + (HPoint div 2));
   with RqImage.Canvas
   do begin
     Brush.Style := bsSolid;
     Brush.Color := RqColor;
     Pen.Mode := pmCopy;
     Pen.Style := psClear;
     RqImage.Canvas.Ellipse(R);
   end;
end;

//     ()    X, Y
procedure AngleRadiusToXY (RqAngle, RqRadius : integer; var X,Y : integer);
begin
  X := Trunc(RqRadius * Cos(RqAngle * 2 * Pi / 360));
  Y := Trunc(RqRadius * Sin(RqAngle * 2 * Pi / 360));
end;

//   Arc Pie Chord
procedure ShowArcPieChord
                  (RqImage : TImage;
                   RqArcPieChord : integer;
                   X,Y,
                   RqRadius,
                   RqAnStart, RqAnStop : integer;
                   RqColor : TColor);
var R  : TRect;
    X3, Y3, X4, Y4 : integer;
begin
    //   
    //    
    R  := Rect(X - RqRadius, Y - RqRadius,
               X + RqRadius, Y + RqRadius);
    //   
    //     (
    //    )
    AngleRadiusToXY(RqAnStart, RqRadius, X3, Y3);
    X3 := X + X3;
    Y3 := Y - Y3;
    AngleRadiusToXY(RqAnStop,  RqRadius, X4, Y4);
    X4 := X + X4;
    Y4 := Y - Y4;
    //   
    with RqImage.Canvas
    do begin
      Brush.Style := bsSolid;
      Brush.Color := RqColor;
      Pen.Mode := pmCopy;
      Pen.Style := psSolid;
      case RqArcPieChord of
      0: //  
          Arc(R.Left,R.Top,
          R.Right,r.Bottom,
          X3, Y3,
          X4, Y4);
      1: //  
          Pie(R.Left,R.Top,
          R.Right,r.Bottom,
          X3, Y3,
          X4, Y4);
      2: //  
          Chord(R.Left,R.Top,
          R.Right,r.Bottom,
          X3, Y3,
          X4, Y4);
       end;
    end;
    //   
    ShowBigPoint(RqImage, X,  Y,  clWhite);
    //   
    ShowBigPoint(RqImage, X3, Y3, clBlue);
    ShowBigPoint(RqImage, X4, Y4, clRed);
    //    
    with RqImage.Canvas
    do begin
       Brush.Style := bsSolid;
       //    
       Brush.Color := RqImage.Parent.Brush.Color;
       TextOut(X, Y  + 2, ' ' );
       TextOut(X3,Y3 + 2, ' ' );
       TextOut(X4,Y4 - TextHeight(''), ' ' );
    end;
end;

//  
procedure TForm1.ButtonPaintClick(Sender: TObject);
begin
    ClearImage (Image1);
    ShowArcPieChord
           (Image1,
            ComboBoxMethod.ItemIndex,
            Image1.Width div 2, Image1.Height div 2,
            150,
            StrToInt(ComboBoxStart.Text),
            StrToInt(ComboBoxStop.Text),
            RGB(200,200,250)
           );
end;

//  
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

end.
